//package com.live.server.console.filter;
//
//import com.alibaba.fastjson.JSON;
//import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
//import com.live.common.constant.ApiResult;
//import com.live.common.enums.ErrorCode;
//import com.live.common.utils.ApiResultUtil;
//import com.live.common.utils.RedisUtil;
//import com.live.server.console.sys.domain.dto.LoginSysDTO;
//import io.swagger.models.HttpMethod;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.web.context.request.RequestAttributes;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//
//import javax.servlet.*;
//import javax.servlet.annotation.WebFilter;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import java.io.IOException;
//import java.io.OutputStream;
//import java.util.Objects;
//
///**
// * @create: 2019-11-20 15:50
// **/
//@Slf4j
//@WebFilter
//@Configuration
//public class HttpFilter implements Filter {
//
//
//    @Autowired
//    private RedisUtil redisUtil;
//
//    @Override
//    public void init(FilterConfig filterConfig) throws ServletException {
//
//    }
//    @Override
//    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
//        // 打印路径和线程id日志
//        log.debug("do filter,{}", Thread.currentThread().getId());
//        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
//        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
//        HttpServletRequest request = sra.getRequest();
//
//        String requestURI = request.getRequestURI();
//        // 将请求信息解析到ReqHeader
//        ReqInfo header = new ReqInfo();
//        header.setDeviceId(StringUtils.trimToEmpty(request.getHeader("device-id")));
//
//
//        HttpLocal.setInfo(header);
//        if (requestURI.contains("/public")|| !request.getMethod().equals(HttpMethod.POST.name())) {
//            filterChain.doFilter(servletRequest, servletResponse);
//            return;
//        }
////        filterChain.doFilter(servletRequest, servletResponse);
//        setRequestHeaderHolder(request, (HttpServletResponse)servletResponse, header, filterChain);
//    }
//
//    /**
//     * 根据缓存获取数据登录基本属性
//     * @param request
//     * @param servletResponse
//     * @param header
//     * @param filterChain
//     */
//    private void setRequestHeaderHolder(HttpServletRequest request, HttpServletResponse servletResponse, ReqInfo header, FilterChain filterChain) {
//            //校验登录
//            String  token = StringUtils.trimToEmpty(request.getHeader("b-token")) ;
//
//            if(StringUtils.isEmpty(token)){
//                writeResponse(servletResponse, ApiResultUtil.getApiResult(ErrorCode.PARAM_ERROR));
//                return;
//            }
//            Object o = redisUtil.get(token);
//
//            if(Objects.isNull(o)){
//                writeResponse(servletResponse,ApiResultUtil.getApiResult(ErrorCode.LOGIN_ERROR));
//                return;
//            }
//
//
//
//
//            String jsonString=JSON.toJSONString(o);
//
//
//             LoginSysDTO tokenInfo = JSON.parseObject(jsonString, LoginSysDTO.class);//(String) o
//
//            String requestURI = request.getRequestURI();
//
//        if(ObjectUtils.isNotNull(tokenInfo.getPathList())){
//            tokenInfo.getPathList().forEach(dto->{
//
//                String[] split = dto.split(",");
//
//                for (int i = 0; i < split.length; i++) {
//
//                    if(requestURI.contains(dto)){
//                        try {
//                            filterChain.doFilter(request, servletResponse);
//                        } catch (IOException e) {
//                            e.printStackTrace();
//                        } catch (ServletException e) {
//                            e.printStackTrace();
//                        }
//                    }
//                }
//            });
//        }
//
//
//        //writeResponse(servletResponse,ApiResultUtil.getApiResult(ErrorCode.LOGIN_ERROR));
//    }
//    @Override
//    public void destroy() {
//
//    }
//
//
//
//    private void writeResponse(ServletResponse response, ApiResult result) {
//        response.setContentType("application/json; charset=utf-8");
//        response.setCharacterEncoding("UTF-8");
//        try {
//            OutputStream out = response.getOutputStream();
//            out.write(JSON.toJSONString(result).getBytes("UTF-8"));
//            out.flush();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }
//}
