package com.live.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.live.common.domain.ResponseData;
import com.live.common.domain.ResultPage;
import com.live.common.domain.dto.back.SysMenuDTO;
import com.live.common.domain.dto.back.SysUserDTO;
import com.live.common.domain.entity.SysUser;
import com.live.common.domain.request.CommonIntId;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.RoleVO;
import com.live.common.domain.request.back.SysEditPwdRequest;
import com.live.common.domain.request.back.UserMenuVO;
import com.live.common.mapper.SysUserMapper;
import com.live.common.service.ISysMenuService;
import com.live.common.service.ISysUserService;
import com.live.common.utils.JWTUtils;
import com.live.common.utils.MD5Util;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;

@Service
@Transactional
@Slf4j
public class SysUserServiceImpl implements ISysUserService {

    @Resource
    private SysUserMapper sysUserMapper;
    @Resource
    private ISysMenuService sysMenuService;
    @Resource
    private SysRoleServiceImpl sysRoleService;

    @Override
    public ResponseData<?> getSysUserList(CommonPage commonPageNum) {
        int jumpNum = (commonPageNum.getPageNum() - 1) * commonPageNum.getPageSize();
        QueryWrapper<SysUser> queryWrapper = new QueryWrapper<SysUser>();
        queryWrapper.ne("deleted", 1);
        long count = sysUserMapper.selectCount(queryWrapper);
        queryWrapper.last(String.format(" limit %s,%s", jumpNum, commonPageNum.getPageSize()));

        List<SysUser> sysUsers = sysUserMapper.selectList(queryWrapper);
        List<SysUserDTO> results = new ArrayList<>();
        for (SysUser sysUser : sysUsers) {
            SysUserDTO sysUserDTO = sysUserConvertDto(sysUser);
            if (sysUser.getRoleId() != null) {
                RoleVO roleVO = (RoleVO) sysRoleService.getSysRoleDetail(sysUser.getRoleId()).getData();
                sysUserDTO.setRoleName(roleVO.getRoleName());
            }
            sysUserDTO.setPassword(null);
            results.add(sysUserDTO);
        }

        return ResponseData.successResponse(new ResultPage(commonPageNum.getPageNum(), commonPageNum.getPageSize(), (int) count, results));
    }

    @Override
    public ResponseData<?> editUserInfo(SysEditPwdRequest sysEditPwdRequest, HttpServletRequest request) {
        SysUser sysUser = sysUserMapper.selectById(sysEditPwdRequest.getId());
        if(sysUser == null){
            return ResponseData.fail400Response("未找到角色账号");
        }

        SysUser sysUserDb = sysUserMapper.selectById(sysUser.getId());
        if(StringUtils.isNotBlank(sysEditPwdRequest.getNewPwd())){
            String password = MD5Util.string2MD5(sysEditPwdRequest.getNewPwd());
            sysUserDb.setPassword(password);
        }
        if(StringUtils.isNotBlank(sysEditPwdRequest.getUserName())){
            sysUserDb.setUsername(sysEditPwdRequest.getUserName());
        }
        if(sysEditPwdRequest.getRoleId() != null){
            sysUserDb.setRoleId(sysEditPwdRequest.getRoleId());
        }
        if(sysEditPwdRequest.getDeleted() != null){
            sysUserDb.setDeleted(sysEditPwdRequest.getDeleted());
        }
        sysUserMapper.updateById(sysUserDb);
        return ResponseData.successResponse();
    }

    @Override
    public ResponseData<?> getSysUser(Integer userId) {
        QueryWrapper<SysUser> wrapper = new QueryWrapper<>();
        wrapper.eq("id", userId);
        SysUser sysUser = sysUserMapper.selectOne(wrapper);
        SysUserDTO sysUserDTO = sysUserConvertDto(sysUser);
        if (sysUserDTO.getRoleId() != null) {
            RoleVO roleVO = (RoleVO) sysRoleService.getSysRoleDetail(sysUserDTO.getRoleId()).getData();
            sysUserDTO.setRoleName(roleVO.getRoleName());
        }

        //渠道翻译
        if (sysUserDTO.getChannel() != null) {
            Map<Integer, String> map = new HashMap<>();
            String[] str = sysUserDTO.getChannel().split(",");
            for (int i = 0; i < str.length; i++) {
                map.put(Integer.valueOf(str[i]), Integer.valueOf(str[i]) == 0 ? "官方" : "渠道" + str[i]);
            }
            sysUserDTO.setChannelMap(map);
        }
        sysUserDTO.setPassword(null);
        return ResponseData.successResponse(sysUserDTO);
    }

    @Override
    public ResponseData<?> menuNames(HttpServletRequest request) {
        String token = request.getHeader("token");
        SysUser sysUser = JWTUtils.getSysUser(token);

        String menuIds = sysUserMapper.getMenuIds(sysUser.getId());
        List<UserMenuVO> menusNames = new ArrayList<>();
        if(menuIds == null){
            return ResponseData.successResponse(null);
        }
        String[] menus = menuIds.split(",");
        for (int i = 0; i < menus.length; i++) {
            UserMenuVO userMenuVO = new UserMenuVO();
            SysMenuDTO sysMenuDTO = (SysMenuDTO) sysMenuService.getSysMenuDTO(Integer.valueOf(menus[i])).getData();
            userMenuVO.setMeunName(sysMenuDTO.getName());
            userMenuVO.setJumpPath(sysMenuDTO.getJumpPath());
            userMenuVO.setSort(sysMenuDTO.getSort());
            menusNames.add(userMenuVO);
        }
        menusNames.sort(new Comparator<UserMenuVO>() {
            @Override
            public int compare(UserMenuVO o1, UserMenuVO o2) {
                int i = o1.getSort() > o2.getSort() ? 1 : -1;
                return i;
            }
        });

        return ResponseData.successResponse(menusNames);
    }

    @Override
    public ResponseData<?> deleteSysUser(CommonIntId commonIntId, HttpServletRequest request) {
        sysUserMapper.deleteById(commonIntId.getId());
        return ResponseData.successResponse();
    }

    @Override
    public ResponseData<?> register(SysUserDTO sysUserDTO) {
        //查询用户名是否存在
        QueryWrapper<SysUser> wrapper = new QueryWrapper<>();

        wrapper.eq("username", sysUserDTO.getUsername());
        SysUser username = sysUserMapper.selectOne(wrapper);
        if (ObjectUtils.isNotNull(username)) {
            return ResponseData.fail500Response("账号名已被注册");
            //throw new GlobalException("账号名已被注册");
        }

        sysUserDTO.setPassword(MD5Util.string2MD5(sysUserDTO.getPassword()));
        SysUser sysUser = sysUserConvert(sysUserDTO);
        if (ObjectUtils.isNotNull(sysUserDTO.getChannelMap())) {
            Set<Map.Entry<Integer, String>> entries = sysUserDTO.getChannelMap().entrySet();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Integer, String> entry : entries) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(entry.getKey());
            }
            sysUser.setChannel(sb.toString());
        }
        sysUserMapper.insert(sysUser);
        return ResponseData.successResponse();
    }

    private SysUserDTO sysUserConvertDto(SysUser sysUser) {
        return SysUserDTO.builder()
                .avatar(sysUser.getAvatar())
                .channel(sysUser.getChannel())
                .deleted(sysUser.getDeleted())
                .email(sysUser.getEmail())
                .id(sysUser.getId())
                .password(sysUser.getPassword())
                .phone(sysUser.getPhone())
                .roleId(sysUser.getRoleId())
                .username(sysUser.getUsername())
                .build();
    }

    private SysUser sysUserConvert(SysUserDTO sysUserDTO) {
        return SysUser.builder()
                .avatar(sysUserDTO.getAvatar())
                .channel(sysUserDTO.getChannel())
                .deleted(sysUserDTO.getDeleted())
                .email(sysUserDTO.getEmail())
                .id(sysUserDTO.getId())
                .online(sysUserDTO.getDeleted())
                .password(sysUserDTO.getPassword())
                .phone(sysUserDTO.getPhone())
                .roleId(sysUserDTO.getRoleId())
                .username(sysUserDTO.getUsername())
                .build();
    }

}
